jQuery(document).ready(function ($) {
    var $overlay = $('#pim-modal-overlay');
    var $iframe = $('#pim-modal-iframe');
    var $loader = $('#pim-loader');
    var $closeBtn = $('#pim-modal-close');
    var $body = $('body');

    // Function to open modal
    function openModal(url) {
        $iframe.attr('src', url);
        $overlay.css('display', 'flex'); // Ensure display flex is set before opacity transition

        // Trigger reflow to ensure transition works
        $overlay[0].offsetHeight;

        $overlay.addClass('active');
        $loader.addClass('active');
        $body.css('overflow', 'hidden'); // Prevent background scrolling

        $iframe.on('load', function () {
            $loader.removeClass('active');
        });
    }

    // Function to close modal
    function closeModal() {
        $overlay.removeClass('active');
        setTimeout(function () {
            $overlay.css('display', 'none');
            $iframe.attr('src', ''); // Clear src to stop any scripts/video
            $loader.removeClass('active');
        }, 300); // Match transition duration
        $body.css('overflow', '');
    }

    // Event Delegation for Menu Items and Custom Links
    $(document).on('click', '.pim-open-modal, .open-in-modal', function (e) {
        e.preventDefault();
        // Check if the clicked element is an <a> tag, or find the closest <a>
        var $link = $(this).is('a') ? $(this) : $(this).closest('a');
        var url = $link.attr('href');

        // Get custom dimensions and colors
        var width = $link.attr('data-pim-width');
        var height = $link.attr('data-pim-height');
        var bgColor = $link.attr('data-pim-bg-color');
        var iconColor = $link.attr('data-pim-icon-color');

        // Reset styles first
        $('.pim-modal-container').css({
            'width': '',
            'height': '',
            'max-width': '', // Reset max-width to allow custom width if smaller/larger but constrained by media query
            'background-color': ''
        });
        $('.pim-modal-close').css('color', '');

        // Apply custom dimensions if they exist
        if (width) {
            $('.pim-modal-container').css('width', width);
        }
        if (height) {
            $('.pim-modal-container').css('height', height);
        }

        // Apply custom colors if they exist
        if (bgColor) {
            $('.pim-modal-container').css('background-color', bgColor);
        }
        if (iconColor) {
            $('.pim-modal-close').css('color', iconColor);
        }

        if (url && url !== '#' && url !== '') {
            openModal(url);
        }
    });

    // Close Button Click
    $closeBtn.on('click', function (e) {
        e.preventDefault();
        closeModal();
    });

    // Overlay Click (to close)
    $overlay.on('click', function (e) {
        if ($(e.target).is('#pim-modal-overlay')) {
            closeModal();
        }
    });

    // Escape Key Press
    $(document).on('keydown', function (e) {
        if (e.key === 'Escape' && $overlay.hasClass('active')) {
            closeModal();
        }
    });
});
