<?php
/**
 * Plugin Name: Page in Modal Pro
 * Description: Allows opening menu items and links in a modal window. Includes Custom Sizes and Colors.
 * Version: 1.1
 * Author: Rafael Arantes
 */

if (!defined('ABSPATH')) {
    exit;
}

// 1. Add Custom Field to Menu Item
function pim_add_custom_menu_fields($item_id, $item, $depth, $args)
{
    $is_modal = get_post_meta($item_id, '_pim_open_in_modal', true);
    $width = get_post_meta($item_id, '_pim_modal_width', true);
    $width_unit = get_post_meta($item_id, '_pim_modal_width_unit', true);
    $height = get_post_meta($item_id, '_pim_modal_height', true);
    $height_unit = get_post_meta($item_id, '_pim_modal_height_unit', true);
    ?>
    <p class="field-pim-open-in-modal description description-wide">
        <label for="edit-menu-item-pim-open-in-modal-<?php echo $item_id; ?>">
            <input type="checkbox" id="edit-menu-item-pim-open-in-modal-<?php echo $item_id; ?>"
                name="menu-item-pim-open-in-modal[<?php echo $item_id; ?>]" value="1" <?php checked($is_modal, 1); ?> />
            <?php _e('Abrir em Modal', 'page-in-modal'); ?>
        </label>
    </p>

    <p class="field-pim-modal-size description description-wide" style="display: block;">
        <label>
            <?php _e('Largura do Modal:', 'page-in-modal'); ?>
            <br>
            <input type="number" name="menu-item-pim-modal-width[<?php echo $item_id; ?>]"
                value="<?php echo esc_attr($width); ?>" style="width: 80px;" placeholder="Ex: 800">
            <select name="menu-item-pim-modal-width-unit[<?php echo $item_id; ?>]">
                <option value="px" <?php selected($width_unit, 'px'); ?>>px</option>
                <option value="%" <?php selected($width_unit, '%'); ?>>%</option>
            </select>
        </label>
    </p>

    <p class="field-pim-modal-size description description-wide" style="display: block;">
        <label>
            <?php _e('Altura do Modal:', 'page-in-modal'); ?>
            <br>
            <input type="number" name="menu-item-pim-modal-height[<?php echo $item_id; ?>]"
                value="<?php echo esc_attr($height); ?>" style="width: 80px;" placeholder="Ex: 600">
            <select name="menu-item-pim-modal-height-unit[<?php echo $item_id; ?>]">
                <option value="px" <?php selected($height_unit, 'px'); ?>>px</option>
                <option value="%" <?php selected($height_unit, '%'); ?>>%</option>
            </select>
        </label>
    </p>

    <!-- Custom Colors -->
    <?php
    $bg_color = get_post_meta($item_id, '_pim_modal_bg_color', true);
    $icon_color = get_post_meta($item_id, '_pim_modal_icon_color', true);
    ?>
    <p class="field-pim-modal-colors description description-wide" style="display: block;">
        <label>
            <?php _e('Cor de Fundo do Modal:', 'page-in-modal'); ?>
            <br>
            <input type="color" name="menu-item-pim-modal-bg-color[<?php echo $item_id; ?>]"
                value="<?php echo esc_attr($bg_color ? $bg_color : '#ffffff'); ?>">
        </label>
    </p>

    <p class="field-pim-modal-colors description description-wide" style="display: block;">
        <label>
            <?php _e('Cor do Botão Fechar (X):', 'page-in-modal'); ?>
            <br>
            <input type="color" name="menu-item-pim-modal-icon-color[<?php echo $item_id; ?>]"
                value="<?php echo esc_attr($icon_color ? $icon_color : '#333333'); ?>">
        </label>
    </p>
    <?php
}
add_action('wp_nav_menu_item_custom_fields', 'pim_add_custom_menu_fields', 10, 4);

// 2. Save Custom Field
function pim_update_custom_menu_fields($menu_id, $menu_item_db_id, $args)
{
    // Save Open in Modal
    $val = isset($_POST['menu-item-pim-open-in-modal'][$menu_item_db_id]) ? 1 : 0;
    update_post_meta($menu_item_db_id, '_pim_open_in_modal', $val);

    // Save Width
    if (isset($_POST['menu-item-pim-modal-width'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_pim_modal_width', sanitize_text_field($_POST['menu-item-pim-modal-width'][$menu_item_db_id]));
    }
    if (isset($_POST['menu-item-pim-modal-width-unit'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_pim_modal_width_unit', sanitize_text_field($_POST['menu-item-pim-modal-width-unit'][$menu_item_db_id]));
    }

    // Save Height
    if (isset($_POST['menu-item-pim-modal-height'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_pim_modal_height', sanitize_text_field($_POST['menu-item-pim-modal-height'][$menu_item_db_id]));
    }
    if (isset($_POST['menu-item-pim-modal-height-unit'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_pim_modal_height_unit', sanitize_text_field($_POST['menu-item-pim-modal-height-unit'][$menu_item_db_id]));
    }

    // Save Colors
    if (isset($_POST['menu-item-pim-modal-bg-color'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_pim_modal_bg_color', sanitize_hex_color($_POST['menu-item-pim-modal-bg-color'][$menu_item_db_id]));
    }
    if (isset($_POST['menu-item-pim-modal-icon-color'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_pim_modal_icon_color', sanitize_hex_color($_POST['menu-item-pim-modal-icon-color'][$menu_item_db_id]));
    }
}
add_action('wp_update_nav_menu_item', 'pim_update_custom_menu_fields', 10, 3);

// 3. Add Class to Menu Link
function pim_nav_menu_link_attributes($atts, $item, $args)
{
    $open_in_modal = get_post_meta($item->ID, '_pim_open_in_modal', true);
    if ($open_in_modal) {
        $class = isset($atts['class']) ? $atts['class'] : '';
        $atts['class'] = $class . ' pim-open-modal';

        // Add Width/Height Data Attributes
        $width = get_post_meta($item->ID, '_pim_modal_width', true);
        $width_unit = get_post_meta($item->ID, '_pim_modal_width_unit', true);
        if (!empty($width)) {
            $atts['data-pim-width'] = $width . ($width_unit ? $width_unit : 'px');
        }

        $height = get_post_meta($item->ID, '_pim_modal_height', true);
        $height_unit = get_post_meta($item->ID, '_pim_modal_height_unit', true);
        if (!empty($height)) {
            $atts['data-pim-height'] = $height . ($height_unit ? $height_unit : 'px');
        }

        // Add Color Data Attributes
        $bg_color = get_post_meta($item->ID, '_pim_modal_bg_color', true);
        if (!empty($bg_color)) {
            $atts['data-pim-bg-color'] = $bg_color;
        }

        $icon_color = get_post_meta($item->ID, '_pim_modal_icon_color', true);
        if (!empty($icon_color)) {
            $atts['data-pim-icon-color'] = $icon_color;
        }
    }
    return $atts;
}
add_filter('nav_menu_link_attributes', 'pim_nav_menu_link_attributes', 10, 3);

// 4. Enqueue Scripts and Styles
function pim_enqueue_scripts()
{
    wp_enqueue_style('pim-style', plugin_dir_url(__FILE__) . 'assets/css/style.css', array(), '1.0');
    wp_enqueue_script('pim-script', plugin_dir_url(__FILE__) . 'assets/js/script.js', array('jquery'), '1.0', true);
}
add_action('wp_enqueue_scripts', 'pim_enqueue_scripts');

// 5. Add Modal HTML to Footer
function pim_add_modal_html()
{
    ?>
    <div id="pim-modal-overlay" class="pim-modal-overlay" style="display: none;">
        <div class="pim-modal-container">
            <button id="pim-modal-close" class="pim-modal-close">&times;</button>
            <div class="pim-modal-content">
                <iframe id="pim-modal-iframe" src="" frameborder="0"></iframe>
            </div>
            <div id="pim-loader" class="pim-loader">Carregando...</div>
        </div>
    </div>
    <?php
}
add_action('wp_footer', 'pim_add_modal_html');
