/**
 * UTM TRK PRO - Script de Administração
 */
(function($) {
    'use strict';
    
    // Função para gerar a URL com parâmetros UTM
    function generateUTMUrl() {
        const url = $('#url').val().trim();
        const utmSource = $('#utm_source').val().trim();
        const utmMedium = $('#utm_medium').val().trim();
        const utmCampaign = $('#utm_campaign').val().trim();
        const utmContent = $('#utm_content').val().trim();
        const utmTerm = $('#utm_term').val().trim();
        
        if (!url) {
            alert('Por favor, informe uma URL válida.');
            return;
        }
        
        if (!utmSource || !utmMedium || !utmCampaign) {
            alert('Os campos UTM Source, UTM Medium e UTM Campaign são obrigatórios.');
            return;
        }
        
        let finalUrl = url;
        const hasParams = url.indexOf('?') !== -1;
        let separator = hasParams ? '&' : '?';
        
        // Adicionar os parâmetros UTM obrigatórios
        finalUrl += separator + 'utm_source=' + encodeURIComponent(utmSource);
        separator = '&';
        
        finalUrl += separator + 'utm_medium=' + encodeURIComponent(utmMedium);
        finalUrl += separator + 'utm_campaign=' + encodeURIComponent(utmCampaign);
        
        // Adicionar os parâmetros UTM opcionais, se preenchidos
        if (utmContent) {
            finalUrl += separator + 'utm_content=' + encodeURIComponent(utmContent);
        }
        
        if (utmTerm) {
            finalUrl += separator + 'utm_term=' + encodeURIComponent(utmTerm);
        }
        
        // Exibir o resultado
        $('#generated-url').val(finalUrl);
        $('.utm-trk-pro-generator-result').show();
    }
    
    // Função para copiar a URL gerada para a área de transferência
    function copyGeneratedUrl() {
        const generatedUrl = $('#generated-url');
        generatedUrl.select();
        document.execCommand('copy');
        
        // Mudar o texto do botão temporariamente
        const copyBtn = $('#copy-url');
        const originalText = copyBtn.html();
        copyBtn.html('<span class="dashicons dashicons-yes"></span> Copiado!');
        
        setTimeout(function() {
            copyBtn.html(originalText);
        }, 2000);
    }
    
    // Inicializar quando o documento estiver pronto
    $(document).ready(function() {
        // Gerador de URL
        $('#generate-utm-url').on('click', generateUTMUrl);
        $('#copy-url').on('click', copyGeneratedUrl);
        
        // Tabs da página de configurações
        $('.nav-tab-wrapper a').on('click', function(e) {
            e.preventDefault();
            const targetTab = $(this).attr('href');
            
            // Atualizar a URL sem recarregar a página
            history.pushState(null, null, targetTab);
            
            // Ativar a tab correta
            $('.nav-tab-wrapper a').removeClass('nav-tab-active');
            $(this).addClass('nav-tab-active');
            
            // Mostrar o conteúdo da tab
            $('.utm-trk-pro-tab-content').hide();
            $(targetTab).show();
        });
        
        // Verificar se há uma tab na URL atual
        const currentTab = window.location.hash;
        if (currentTab) {
            $('.nav-tab-wrapper a[href="' + currentTab + '"]').trigger('click');
        } else {
            // Ativar a primeira tab por padrão
            $('.nav-tab-wrapper a').first().trigger('click');
        }
    });
    
})(jQuery);