<?php
/**
 * Classe principal do plugin UTM TRK PRO
 */
class UTM_TRK_Pro {
    
    // Instância única da classe (padrão singleton)
    private static $instance = null;
    
    // Instâncias das classes auxiliares
    private $settings;
    private $admin;
    private $tracking;
    
    /**
     * Retorna a instância única da classe
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Inicializa o plugin
     */
    private function __construct() {
        // Carregar tradução
        add_action('plugins_loaded', array($this, 'load_textdomain'));
        
        // Inicializar as classes auxiliares
        $this->settings = new UTM_TRK_Pro_Settings();
        $this->admin = new UTM_TRK_Pro_Admin($this->settings);
        $this->tracking = new UTM_TRK_Pro_Tracking($this->settings);
        
        // Adicionar link de configurações na página de plugins
        add_filter('plugin_action_links_' . plugin_basename(UTM_TRK_PRO_PATH . 'utm-trk-pro.php'), array($this, 'add_settings_link'));
        
        // Verificar e atualizar da versão anterior
        add_action('admin_init', array($this, 'check_upgrade'));
    }
    
    /**
     * Carrega os arquivos de tradução
     */
    public function load_textdomain() {
        load_plugin_textdomain('utm-trk-pro', false, dirname(plugin_basename(UTM_TRK_PRO_PATH)) . '/languages');
    }
    
    /**
     * Adiciona link para as configurações na lista de plugins
     */
    public function add_settings_link($links) {
        $settings_link = '<a href="' . esc_url(admin_url('admin.php?page=utm-trk-pro-settings')) . '">' . esc_html__('Configurações', 'utm-trk-pro') . '</a>';
        array_unshift($links, $settings_link);
        return $links;
    }
    
    /**
     * Verifica se é necessário atualizar de uma versão anterior
     */
    public function check_upgrade() {
        $installed_version = get_option('utm_trk_pro_version', '0');
        
        if (version_compare($installed_version, UTM_TRK_PRO_VERSION, '<')) {
            // Realizar atualizações necessárias aqui
            
            // Atualizar a versão no banco de dados
            update_option('utm_trk_pro_version', UTM_TRK_PRO_VERSION);
        }
    }
    
    /**
     * Hook de ativação do plugin
     */
    public static function activate() {
        // Verificar versão mínima do WordPress
        if (version_compare($GLOBALS['wp_version'], '5.0', '<')) {
            deactivate_plugins(plugin_basename(__FILE__));
            wp_die(esc_html__('O UTM TRK PRO requer WordPress 5.0 ou superior.', 'utm-trk-pro'));
        }
        
        // Verificar versão mínima do PHP
        if (version_compare(PHP_VERSION, '7.2', '<')) {
            deactivate_plugins(plugin_basename(__FILE__));
            wp_die(esc_html__('O UTM TRK PRO requer PHP 7.2 ou superior.', 'utm-trk-pro'));
        }
        
        // Adicionar opções padrão
        $default_options = array(
            'enable_tracking' => 'yes',
            'track_external' => 'yes',
            'track_internal' => 'yes',
            'excluded_domains' => '',
            'cookie_duration' => 30,
            'default_utm_source' => '',
            'default_utm_medium' => '',
            'default_utm_campaign' => '',
            'enable_analytics' => 'no',
        );
        
        add_option('utm_trk_pro_options', $default_options);
        add_option('utm_trk_pro_version', UTM_TRK_PRO_VERSION);
    }
    
    /**
     * Hook de desativação do plugin
     */
    public static function deactivate() {
        // Não remover as opções no caso de uma desativação temporária
    }
    
    /**
     * Obtém as configurações do plugin
     */
    public function get_settings() {
        return $this->settings;
    }
    
    /**
     * Obtém a instância do admin
     */
    public function get_admin() {
        return $this->admin;
    }
    
    /**
     * Obtém a instância de rastreamento
     */
    public function get_tracking() {
        return $this->tracking;
    }
}
