<?php
/**
 * Plugin Name: UTM TRK PRO
 * Plugin URI: https://www.rafaelarantes.com.br
 * Description: Versão profissional do plugin para transferir e gerenciar parâmetros UTM para links.
 * Version: 2.0.0
 * Author: Rafael Arantes
 * Author URI: https://www.rafaelarantes.com.br
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: utm-trk-pro
 * Domain Path: /languages
 */

// Evitar acesso direto ao arquivo
if (!defined('ABSPATH')) {
    exit;
}

// Definir constantes para o plugin
define('UTM_TRK_PRO_VERSION', '2.0.0');
define('UTM_TRK_PRO_PATH', plugin_dir_path(__FILE__));
define('UTM_TRK_PRO_URL', plugin_dir_url(__FILE__));

// Incluir arquivos necessários
require_once UTM_TRK_PRO_PATH . 'includes/class-utm-trk-pro-settings.php';
require_once UTM_TRK_PRO_PATH . 'includes/class-utm-trk-pro-admin.php';
require_once UTM_TRK_PRO_PATH . 'includes/class-utm-trk-pro-tracking.php';
require_once UTM_TRK_PRO_PATH . 'includes/class-utm-trk-pro.php';

// Hook de ativação
register_activation_hook(__FILE__, array('UTM_TRK_Pro', 'activate'));

// Hook de desativação
register_deactivation_hook(__FILE__, array('UTM_TRK_Pro', 'deactivate'));

// Inicializar o plugin
function utm_trk_pro_init() {
    return UTM_TRK_Pro::get_instance();
}

// Iniciar o plugin quando todos os plugins forem carregados
add_action('plugins_loaded', 'utm_trk_pro_init');
